/*
	arrays.js
	JavaScript additions for Array objects
	Verison 1.0 / august 2005
	
	Patrick Machielse (c) 2005
	Hieper Software
*/
	
//	----------------------------------------------------------------------
//	ARRAY ADDITIONS
//	----------------------------------------------------------------------

//	Check if array contains object
function contains(object) {
	for ( var i = 0, len = this.length; i != len; i++ ) {
		if ( this[i] == object ) { return true;	}
	}
	return false;
}
Array.prototype.contains = contains;

//	Exchange objects at index i and j
function swap(i, j) {
	if ( i == j ) return;
	var tmp = this[i];
	this[i] = this[j];
	this[j] = tmp;
}
Array.prototype.swap = swap;

//	Perform passed function with each contained object as argument
//	myFunction should have 1 object argument
//	returns an array with return values
function withAll(myFunction) {
	var ret = new Array(this.length);
	for ( var i = 0, len = this.length; i != len; i++ ) {
		ret[i] = myFunction(this[i]);
	}
	return ret;
}	
Array.prototype.withAll = withAll;
